IF EXISTS (SELECT * FROM SYS.triggers WHERE NAME = 'TRG_EST_SNGPC_ENTRADA_ESTOQUE_UPDATE') 
BEGIN
	DROP TRIGGER TRG_EST_SNGPC_ENTRADA_ESTOQUE_UPDATE
END



SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER dbo.TRG_EST_SNGPC_ENTRADA_ESTOQUE_UPDATE ON dbo.EST_SNGPC_ENTRADA
WITH EXECUTE AS CALLER
FOR UPDATE
AS
BEGIN

	-- DECLARAO DAS VARIVEIS
	DECLARE @CD_ENT      INT;
	DECLARE @CD_MOV      INT;
	DECLARE @CD_MOV_PRI  INT;
	DECLARE @CD_MOV_ANT  INT;
	DECLARE @CD_MOV_POS  INT;
	DECLARE @CD_EMP      INT;
	DECLARE @CD_FILIAL   INT;
	DECLARE @CD_PROD     INT;
	DECLARE @DT_MOV      DATETIME;
	DECLARE @DT_MOV_ANT  DATETIME;
	DECLARE @DT_REINICIO DATETIME;
	DECLARE @QT_LOTE     INT;
	DECLARE @QT_ANT      INT;

	-- DEFINIO DAS VARIVEIS
	SELECT
		@CD_ENT        = I.CD_ENT_SNGPC
		, @CD_EMP      = I.CD_EMP
		, @CD_FILIAL   = I.CD_FILIAL
		, @CD_PROD     = I.CD_PROD
		, @DT_MOV      = I.DT_MOV
		, @QT_LOTE     = I.QT_LOTE
	FROM
		INSERTED I;

	-- SELECIONA A DATA DE REINCIO DO INVENTRIO
	SELECT
		TOP 1
		@DT_REINICIO = DT_REINICIO
	FROM
		EST_SNGPC_REINICIO_INVENTARIO (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
	ORDER BY
		CD_REINICIO DESC;

	IF @DT_REINICIO IS NULL
		SET @DT_REINICIO = '1900-01-01';

	SELECT
		@DT_MOV_ANT = DT_MOV
		, @QT_ANT   = QT_LOTE
	FROM DELETED;

	-- SELECIONA A MOVIMENTAO GERAL CORRESPONDENTE  ENTRADA
	SELECT
		@CD_MOV = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_ENT_SNGPC = @CD_ENT

	-- SELECIONA A PRIMEIRA MOVIMENTAO DO PRODUTO
	SELECT
		TOP 1
		@CD_MOV_PRI = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND DT_MOV    > @DT_REINICIO
	ORDER BY
		DT_MOV, CD_MOV

	-- SELECIONA A MOVIMENTAO ANTERIOR
	SELECT 
		TOP 1
		@CD_MOV_ANT = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND CD_MOV   <> @CD_MOV
		AND (DT_MOV < @DT_MOV OR (DT_MOV = @DT_MOV AND CD_MOV < @CD_MOV))
		AND DT_MOV    > @DT_REINICIO
	ORDER BY
		DT_MOV DESC
		, CD_MOV DESC;

	-- SELECIONAR A MOVIMENTAO POSTERIOR
	SELECT 
		TOP 1
		@CD_MOV_POS = CD_MOV
	FROM
		EST_SNGPC_ENT_SAI (NOLOCK)
	WHERE
		CD_EMP        = @CD_EMP
		AND CD_FILIAL = @CD_FILIAL
		AND CD_PROD   = @CD_PROD
		AND (DT_MOV > @DT_MOV OR (DT_MOV = @DT_MOV AND CD_MOV > @CD_MOV))
		AND DT_MOV    > @DT_REINICIO
	ORDER BY
		DT_MOV
		, CD_MOV;

	/*********************************************************************/
	/* PROCESSO PARA ATUALIZAO DO REGISTRO NA TABELA EST_SNGPC_ENT_SAI */
	/*********************************************************************/

	-- VERIFICA SE A NOVA DATA  POSTERIOR A DATA ANTIGA
	IF @DT_MOV > @DT_MOV_ANT
		-- SE POSTERIOR
		BEGIN
			-- ATUALIZA O ESTOQUE DAS MOVIMENTAES ANTERIORES
			UPDATE
				EST_SNGPC_ENT_SAI 
			SET
				QT_FINAL = QT_FINAL - COALESCE(@QT_ANT, 0)
			WHERE
				CD_EMP        = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_PROD   = @CD_PROD
				AND (DT_MOV > @DT_MOV_ANT OR (DT_MOV = @DT_MOV_ANT AND CD_MOV > @CD_MOV))
				AND (DT_MOV < @DT_MOV     OR (DT_MOV = @DT_MOV     AND CD_MOV < @CD_MOV))
				AND DT_MOV    > @DT_REINICIO;
		END;

	-- VERIFICA SE EXISTE MOVIMENTAO ANTERIOR
	IF @CD_MOV_ANT IS NULL
		-- SE NO EXISTIR MOVIMENTAO ANTERIOR
		BEGIN
			-- VERIFICA SE EXISTE MOVIMENTAO POSTERIOR E SE ESSA  A PRIMEIRA MOVIMENTAO
			IF (@CD_MOV_POS IS NOT NULL) AND (@CD_MOV <> @CD_MOV_PRI)
				-- SE EXISTIR MOVIMENTAO POSTERIOR E NO FOR A PRIMEIRA MOVIMENTAO
				BEGIN
					-- ATUALIZA O REGISTRO USANDO O ESTOQUE POSTERIOR
					UPDATE
						EST_SNGPC_ENT_SAI 
					SET
						DT_MOV     = @DT_MOV
						, QT_FINAL = (
							SELECT 
								(
									CASE
										WHEN A.CD_ENT_SNGPC IS NULL THEN
											A.QT_FINAL + C.QT_LOTE
										ELSE
											A.QT_FINAL - B.QT_LOTE
									END
								) 
							FROM 
								EST_SNGPC_ENT_SAI (NOLOCK)  A 
								LEFT JOIN EST_SNGPC_ENTRADA (NOLOCK) B ON 
									A.CD_ENT_SNGPC = B.CD_ENT_SNGPC 
								LEFT JOIN EST_SNGPC_SAIDA (NOLOCK) C ON
									A.CD_SAI_SNGPC = C.CD_SAI_SNGPC
							WHERE 
								A.CD_MOV = @CD_MOV_POS
						) + @QT_LOTE
					WHERE
						CD_MOV = @CD_MOV;
				END;
			ELSE
				-- SE NO EXISTIR MOVIMENTAO POSTERIOR OU SE FOR A PRIMEIRA MOVIMENTAO
				BEGIN
					-- ATUALIZA O REGISTRO USANDO O PRPRIO ESTOQUE
					UPDATE
						EST_SNGPC_ENT_SAI 
					SET
						DT_MOV     = @DT_MOV
						, QT_FINAL = QT_FINAL + (@QT_LOTE - COALESCE(@QT_ANT, 0))
					WHERE
						CD_MOV = @CD_MOV;
				END
		END
	ELSE
		-- SE EXISTIR MOVIMENTAO ANTERIOR
		BEGIN
			-- ATUALIZA O REGISTRO USANDO O ESTOQUE ANTERIOR
			UPDATE
				EST_SNGPC_ENT_SAI 
			SET
				DT_MOV     = @DT_MOV
				, QT_FINAL = (SELECT QT_FINAL FROM EST_SNGPC_ENT_SAI (NOLOCK) WHERE CD_MOV = @CD_MOV_ANT) + @QT_LOTE
			WHERE
				CD_MOV = @CD_MOV;
		END;

	/**********************************************/
	/* PROCESSO PARA ATUALIZAO DO ESTOQUE FINAL */
	/* DOS REGISTROS NA TABELA EST_SNGPC_ENT_SAI  */
	/**********************************************/

	-- VERIFICA SE A NOVA DATA  IGUAL OU POSTERIOR A ANTIGA DATA
	IF (@DT_MOV >= @DT_MOV_ANT)
		-- SE A NOVA DATA FOR IGUAL OU POSTERIOR A ANTIGA DATA
		BEGIN
			-- ATUALIZA O ESTOQUE DE TODAS AS MOVIMENTAES POSTERIORES
			UPDATE
				EST_SNGPC_ENT_SAI 
			SET
				QT_FINAL = QT_FINAL + (@QT_LOTE - COALESCE(@QT_ANT, 0))
			WHERE
				CD_EMP        = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_PROD   = @CD_PROD
				AND (DT_MOV > @DT_MOV OR (DT_MOV = @DT_MOV AND CD_MOV > @CD_MOV))
				AND DT_MOV    > @DT_REINICIO;
		END
	ELSE
		-- SE A NOVA DATA FOR ANTERIOR A ANTIGA DATA
		BEGIN
			-- ATUALIZA O ESTOQUE DAS MOVIMENTAES AT A DATA ANTIGA
			UPDATE
				EST_SNGPC_ENT_SAI 
			SET
				QT_FINAL = QT_FINAL + @QT_LOTE
			WHERE
				CD_EMP        = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_PROD   = @CD_PROD
				AND (DT_MOV < @DT_MOV_ANT OR (DT_MOV = @DT_MOV_ANT AND CD_MOV < @CD_MOV))
				AND (DT_MOV > @DT_MOV     OR (DT_MOV = @DT_MOV     AND CD_MOV > @CD_MOV))
				AND DT_MOV    > @DT_REINICIO;

			-- ATUALIZA O ESTOQUE DAS MOVIMENTAES POSTERIORES A DATA ANTIGA
			UPDATE
				EST_SNGPC_ENT_SAI
			SET
				QT_FINAL = QT_FINAL + (@QT_LOTE - COALESCE(@QT_ANT, 0))
			WHERE
				CD_EMP        = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_PROD   = @CD_PROD
				AND (DT_MOV > @DT_MOV_ANT OR (DT_MOV = @DT_MOV_ANT AND CD_MOV > @CD_MOV))
				AND DT_MOV    > @DT_REINICIO;
		END;

END
GO